ORCA/M Asm65816 2.1.0

0001 8438
0002 8438
0003 8438              ********************************************************
0004 8438              *
0005 8438              * Serve.gen: This routine will update the waveform pointers for a
0006 8438              *            oscillator.
0007 8438              *
0008 8438              ********************************************************
0009 8438
0010 8438
0011 8438              ***	include 'all.macros'	;removed 17-Sep-90 DAL
0012 8438                       include 'm16.util2' 
0013 8438                       include 'Snd.Equ.aii' 
0014 8438
0015 8438                       import set_gcb 
0016 8438                       import set_doc_regs 
0017 8438
0018 8438                       LONGA OFF
0019 8438                       LONGI OFF
0020 8438
0021 8438                       export serve_gen 
0022 8438
0023 8438              serve_gen proc                          ; service oscillator irq
0024 8438 B5 00                 lda   gcb_tbl,x                ; get the mode byte
0025 843A F0 47                 beq   exit_serve_gen           ; this one not in use
0026 843C
0027 843C 29 0F                 and   #$0F                     ; 4 bits of mode
0028 843E C9 01                 cmp   #ffsynth_mode            ; is it our mode?
0029 8440 D0 42                 bne   other_mode               ; not ours pass control
0030 8442
0031 8442 B5 00                 lda   gcb_tbl,x                ; get the mode back
0032 8444 10 43                 bpl   next_wave_chunk          ; waveform completed
0033 8446
0034 8446                       LONGA ON
0035 8446
0036 8446 C2 20        chk_pblock rep   #$20                   ; check for another param block
0037 8448 B5 07                 lda   gcbp_ptr,x               ; get the pointer
0038 844A 15 08                 ora   gcbp_ptr+1,x
0039 844C F0 2E                 beq   no_more_waves
0040 844E
0041 844E                       export set_pblock 
0042 844E
0043 844E              set_pblock  
0044 844E B5 00                 lda   gcb_mode,x               ; get the mode
0045 8450 29 7F FF              and   #$FF7F                   ; mask off wave ended bit
0046 8453 48                    pha                            ; save the mode & gen number
0047 8454 B5 09                 lda   gcbp_ptr+2,x             ; get next wave parameter pointers
0048 8456 29 FF 00              and   #$00FF                   ; low byte only
0049 8459 48                    pha                            ; save upper word of parameter block
0050 845A B5 07                 lda   gcbp_ptr,x               ; get low word of parameter block
0051 845C 48                    pha   
0052 845D A9 00 00              lda   #$0000                   ; reset mode byte & gen. number
0053 8460 95 00                 sta   gcb_mode,x
0054 8462 3B                    tsc                            ; get stack pointer
0055 8463 38                    sec   
0056 8464 E9 09 00              sbc   #$09                     ; cheat a bunch
0057 8467 1B                    tcs   
0058 8468
0059 8468 20 57 88              jsr   set_gcb                  ; set the generator control block
0060 846B
0061 846B 3B                    tsc                            ; get the stack pointer
0062 846C 18                    clc                            ;
0063 846D 69 0F 00              adc   #$0F                     ; put the stack back
0064 8470 1B                    tcs                            ; put the stack back
0065 8471
0066 8471                       LONGA OFF
0067 8471
0068 8471 E2 20                 sep   #$20
0069 8473 A9 03                 lda   #$03                     ; new wave/must set doc regs.
0070 8475 95 0F                 sta   gcb_new_wave,x           ;
0071 8477 20 89 87              jsr   next_wave_chunk          ; move next block of wave
0072 847A 80 07                 bra   exit_serve_gen           ; keep going
0073 847C
0074 847C
0075 847C              no_more_waves  
0076 847C                       LONGA OFF
0077 847C
0078 847C E2 20                 sep   #$20
0079 847E A9 01                 lda   #$01                     ; halt this oscillator
0080 8480 20 31 88              jsr   sdoc_ctrl                ; set the control byte in the DOC
0081 8483
0082 8483              exit_serve_gen  
0083 8483 60                    rts                            ; >>>--- exit serve.gen --->>>
0084 8484
0085 8484
0086 8484
0087 8484
0088 8484              other_mode                              ; user defined mode
0089 8484 22 BD 1D E1           jsl   sram_base+user_irq       ; call their handler
0090 8488 60                    rts                            ; all done with this one
0091 8489
0092 8489
0093 8489
0094 8489
0095 8489
0096 8489
0097 8489
0098 8489
0099 8489                       export next_wave_chunk 
0100 8489
0101 8489              next_wave_chunk  
0102 8489 A9 60                 lda   #gptrinc+gramsel         ; select DOC ram with auto incr
0103 848B 0F CA 00 E1           ora   >irq_volume              ; include system volume
0104 848F 8F 3C C0 E1           sta   gstatreg
0105 8493 A5 F6                 lda   osc_num_temp             ; get the oscillator number
0106 8495
0107 8495                       LONGA ON
0108 8495                       LONGI ON
0109 8495
0110 8495 C2 30                 rep   #$30
0111 8497 6A                    ror   A                        ; even or odd oscillator
0112 8498 B5 0A                 lda   gcb_O0_start,x           ; get the DOC wave buffer start address
0113 849A 90 03                 bcc   set_even
0114 849C
0115 849C 18                    clc   
0116 849D 75 0C                 adc   gcb_doc_count,x          ; odd oscillator DOC buffer
0117 849F 8F 3E C0 E1  set_even sta   gadrl                    ; set DOC ram address
0118 84A3 08                    php                            ; save micro status register
0119 84A4 B5 02                 lda   gcb_wave_pos,x           ; set source work pointer
0120 84A6 85 F0                 sta   scratch                  ;
0121 84A8 B5 03                 lda   gcb_wave_pos+1,x
0122 84AA 85 F1                 sta   scratch+1
0123 84AC B5 0C                 lda   gcb_doc_count,x          ; get the number of bytes to move
0124 84AE EB                    xba                            ; save number of pages to move
0125 84AF 85 F8                 sta   page_count               ; save number of bytes to move
0126 84B1 A0 00 00              ldy   #$0000                   ; reset work counter
0127 84B4 B5 05                 lda   gcb_wave_count,x         ; check for end of wave
0128 84B6 F0 21                 beq   wave_done
0129 84B8
0130 84B8 E2 30        wave_mover sep   #$30                   ; 8 bits please
0131 84BA
0132 84BA              move_loop                               ;
0133 84BA B7 F0                 lda   [scratch],y              ; get a byte
0134 84BC 8F 3D C0 E1           sta   gdatreg                  ; write it to the sound glu
0135 84C0 C8                    iny   
0136 84C1 D0 F7                 bne   move_loop                ; move one page
0137 84C3 C2 20                 rep   #$20
0138 84C5 E6 F1                 inc   scratch+1                ; bump source pointer
0139 84C7 D6 05                 dec   gcb_wave_count,x         ; decrement wave page count
0140 84C9 F0 0E                 beq   wave_done                ;
0141 84CB
0142 84CB C6 F8                 dec   page_count               ; decr number pages to move
0143 84CD D0 E9                 bne   wave_mover
0144 84CF A5 F0                 lda   scratch                  ; set new wave start position
0145 84D1 95 02                 sta   gcb_wave_pos,x
0146 84D3 A5 F1                 lda   scratch+1
0147 84D5 95 03                 sta   gcb_wave_pos+1,x
0148 84D7 80 40                 bra   exit_wave_mover          ; all done for this block
0149 84D9
0150 84D9              wave_done                               ;
0151 84D9 A5 F8                 lda   page_count               ; did we fill the DOC buffer?
0152 84DB 3A                    dec   A
0153 84DC F0 0D                 beq   @1
0154 84DE
0155 84DE                       LONGA OFF
0156 84DE                       LONGI OFF
0157 84DE
0158 84DE E2 30                 sep   #$30
0159 84E0 A9 00                 lda   #$00                     ; pad with 8 zeros
0160 84E2 A0 40                 ldy   #$40                     ; need 64 zeroes
0161 84E4 8F 3D C0 E1  @2       sta   gdatreg
0162 84E8 88                    dey   
0163 84E9 D0 F9                 bne   @2
0164 84EB
0165 84EB                       LONGA OFF
0166 84EB
0167 84EB              @1        
0168 84EB E2 20                 sep   #$20
0169 84ED
0170 84ED              * make sure if it is the first time this osc has played,
0171 84ED              * that it has the freq and stuff set up. so just copy the code as if it wasn't,
0172 84ED              * done, and then set the mode.
0173 84ED
0174 84ED A5 F6                 lda   osc_num_temp             ; get the oscillator number
0175 84EF 29 01                 and   #$01                     ; check for even or odd osc
0176 84F1 18                    clc                            ; assume odd oscillator
0177 84F2 D0 02                 bne   @3
0178 84F4
0179 84F4 80 0C                 bra   @4                       ; if not odd don't mess with it.
0180 84F6              @3        
0181 84F6 2A                    rol   A
0182 84F7 35 0F                 and   gcb_new_wave,x           ; get the new wave marker
0183 84F9
0184 84F9              *** Bug Fix 2/7/90 MLC
0185 84F9
0186 84F9              *        beq   end_wave_move            ; BUG - LastBlock bit will NOT be set!!!!!
0187 84F9 F0 07                 beq   @4                       ; now it's set....
0188 84FB
0189 84FB 55 0F                 eor   gcb_new_wave,x           ; clear even/odd oscillator bit
0190 84FD 95 0F                 sta   gcb_new_wave,x           ; and save updated marker
0191 84FF 20 8A 89              jsr   set_doc_regs             ; setup doc registers
0192 8502
0193 8502              * now the freq and stuff should be all set up.
0194 8502
0195 8502 A9 80        @4       lda   #$80                     ; mark wave done in mode byte
0196 8504 15 00                 ora   gcb_mode,x
0197 8506 95 00                 sta   gcb_mode,x
0198 8508 C2 20                 rep   #$20                     ; check for more waves
0199 850A B5 07                 lda   gcbp_ptr,x
0200 850C 15 08                 ora   gcbp_ptr+1,x
0201 850E D0 09                 bne   exit_wave_mover          ; leave control alone if more waves to follow
0202 8510
0203 8510                       LONGA OFF
0204 8510
0205 8510 E2 20                 sep   #$20
0206 8512 A9 03                 lda   #03                      ; set to play & halt when done
0207 8514 20 31 88              jsr   sdoc_ctrl                ; set control register
0208 8517 80 16                 bra   end_wave_move
0209 8519
0210 8519              exit_wave_mover  
0211 8519                       LONGA OFF
0212 8519
0213 8519 E2 20                 sep   #$20
0214 851B A5 F6                 lda   osc_num_temp             ; get the oscillator number
0215 851D 29 01                 and   #$01                     ; check for even or odd osc
0216 851F 18                    clc                            ; assume odd oscillator
0217 8520 D0 01                 bne   @1
0218 8522
0219 8522 38                    sec   
0220 8523              @1        
0221 8523 2A                    rol   A
0222 8524 35 0F                 and   gcb_new_wave,x           ; get the new wave marker
0223 8526 F0 07                 beq   end_wave_move
0224 8528 55 0F                 eor   gcb_new_wave,x           ; clear even/odd oscillator bit
0225 852A 95 0F                 sta   gcb_new_wave,x           ; and save updated marker
0226 852C 20 8A 89              jsr   set_doc_regs             ; setup doc registers
0227 852F
0228 852F              end_wave_move  
0229 852F 28                    plp                            ; restore micro status
0230 8530 60                    rts                            ; >>>--- exit wave.mover --->>>
0231 8531
0232 8531
0233 8531
0234 8531
0235 8531
0236 8531
0237 8531
0238 8531
0239 8531                       TITLE 'Shut oscillator off' 
0240 8531                       EJECT 
0241 8531              ********************************************************
0242 8531              *
0243 8531              * sdoc.ctrl: Sets the control register for a oscillator.
0244 8531              *
0245 8531              *     Import: AL = contents to write to osc. control reg.
0246 8531              *
0247 8531              ********************************************************
0248 8531              ;
0249 8531              ;
0250 8531                       export sdoc_ctrl 
0251 8531
0252 8531
0253 8531              sdoc_ctrl  
0254 8531 48                    pha                            ; save control byte
0255 8532 A9 00                 lda   #00                      ; point to DOC no auto incr.
0256 8534 0F CA 00 E1           ora   >irq_volume              ; include system volume
0257 8538 8F 3C C0 E1           sta   gstatreg                 ;
0258 853C 18                    clc   
0259 853D A5 F6                 lda   osc_num_temp             ; get oscillator number
0260 853F 69 A0                 adc   #eocr                    ; point to control register
0261 8541 8F 3E C0 E1           sta   gadrl
0262 8545 AF 3D C0 E1           lda   gdatreg                  ; false read.
0263 8549 AF 3D C0 E1           lda   gdatreg                  ; get current stereo position.
0264 854D 29 F0                 and   #$F0                     ; get stereo setting.
0265 854F 03 01                 ora   1,s                      ; or in control byte.
0266 8551 8F 3D C0 E1           sta   gdatreg                  ; write out control byte
0267 8555 68                    pla                            ; remove the control byte.
0268 8556 60                    rts                            ; >>>--- exit sdoc.ctrl --->>>
0269 8557
0270 8557                       endp 
0271 8557                       end   
